/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.uddi;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.base.VWUDDIRegistryList;
import filenet.vw.toolkit.admin.property.uddi.VWConfigRegionBusinessEntityPanel;
import filenet.vw.toolkit.admin.property.uddi.VWConfigUDDIRegistryListPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.ws.IVWUDDIPanelOperation;
import filenet.ws.utils.WSConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class VWConfigUDDIInfoPanel
extends JPanel
implements ChangeListener {
    private VWUDDIRegistryList m_uddiRegistryList = null;
    private Frame m_parentFrame = null;
    private VWSession m_vwSession = null;
    private VWSessionInfo m_sessionInfo = null;
    private boolean m_bChanged = false;
    private JTabbedPane m_tabbedPanel = new JTabbedPane();
    private VWConfigRegionBusinessEntityPanel m_regionBusinessEntityPanel = null;
    private VWConfigUDDIRegistryListPanel m_uddiRegistryListPanel = null;
    private Component m_currentSelectedTab = null;

    public VWConfigUDDIInfoPanel(Frame parentFrame, VWSessionInfo sessionInfo, VWAttributeInfo vwAttributeInfo) {
        try {
            this.m_parentFrame = parentFrame;
            this.m_sessionInfo = sessionInfo;
            this.m_vwSession = sessionInfo.getSession();
            this.m_uddiRegistryList = new VWUDDIRegistryList(vwAttributeInfo, this.m_vwSession);
            this.m_tabbedPanel.addChangeListener(this);
            this.createControls();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean hasChanged() {
        return this.m_regionBusinessEntityPanel.hasChanged() || this.m_uddiRegistryListPanel.hasChanged();
    }

    public boolean update() {
        boolean bSuccess = true;
        try {
            this.stopEditing();
            if (this.m_regionBusinessEntityPanel.hasChanged()) {
                bSuccess = this.m_regionBusinessEntityPanel.update();
                this.m_bChanged = true;
            }
            if (bSuccess && this.m_uddiRegistryListPanel.hasChanged()) {
                bSuccess = this.m_uddiRegistryListPanel.update();
                this.m_bChanged = true;
            }
            if (this.m_bChanged && bSuccess) {
                this.m_uddiRegistryList.updateAttribute();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 1);
        }
        return bSuccess;
    }

    public void createControls() {
        try {
            Font aFont = this.getFont();
            this.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setLayout(new BorderLayout(4, 4));
            this.m_tabbedPanel.setFont(new Font(aFont.getName(), 1, aFont.getSize()));
            VWAccessibilityHelper.setAccessibility(this.m_tabbedPanel, this, VWResource.UDDIInfoTabbedPane, VWResource.UDDIInfoTabbedPane);
            this.m_tabbedPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            String baseURL = this.m_sessionInfo.getProperty("baseURL");
            String inquiryURL = null;
            if (baseURL != null) {
                if (!baseURL.endsWith("/")) {
                    baseURL = baseURL + "/";
                }
                inquiryURL = baseURL + "P8BPMWSBroker" + "/wscp" + WSConstants.UTF8Encode(this.m_vwSession.getConnectionPointName()) + "/uddiv2/inquire";
            }
            this.m_regionBusinessEntityPanel = new VWConfigRegionBusinessEntityPanel(this.m_parentFrame, this.m_uddiRegistryList, inquiryURL);
            this.m_tabbedPanel.add(VWResource.RegionBusinessEntity, this.m_regionBusinessEntityPanel);
            this.m_uddiRegistryListPanel = new VWConfigUDDIRegistryListPanel(this.m_parentFrame, this.m_uddiRegistryList);
            this.m_tabbedPanel.add(VWResource.UDDIRegistryList, this.m_uddiRegistryListPanel);
            this.add(this.m_tabbedPanel);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_uddiRegistryList != null) {
            this.m_uddiRegistryList.releaseResources();
            this.m_uddiRegistryList = null;
        }
        this.removeAll();
    }

    public void stateChanged(ChangeEvent event) {
        boolean bOk = true;
        Object sourceObject = event.getSource();
        if (sourceObject == this.m_tabbedPanel) {
            Component aComponent;
            if (this.m_currentSelectedTab != null) {
                IVWUDDIPanelOperation panelOperation = (IVWUDDIPanelOperation)((Object)this.m_currentSelectedTab);
                panelOperation.stopEditing();
                if (panelOperation.hasChanged() && (bOk = panelOperation.validateData())) {
                    bOk = panelOperation.update();
                }
            }
            this.m_currentSelectedTab = aComponent = this.m_tabbedPanel.getSelectedComponent();
        }
    }

    private void stopEditing() {
        if (this.m_regionBusinessEntityPanel != null) {
            this.m_regionBusinessEntityPanel.stopEditing();
        }
        if (this.m_uddiRegistryListPanel != null) {
            this.m_uddiRegistryListPanel.stopEditing();
        }
    }
}

